#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//experiment_0609_fake lettersMod01.fsh   by  phi16
//https://www.shadertoy.com/view/WtjGzG
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float rand(vec2 co){
    return fract(sin(dot(co.xy, vec2(12.9898,78.233))) * 43758.5453);
}

float centerize(float x) {
    float a = 1.5; // 0 < a < 4
    return a*x*x*x - 1.5*a*x*x + (0.5*a+1.)*x;
}

vec3 pieces(vec2 p, vec2 s, vec2 seed, bool simpleForm) {
	float line = 0.1;
    float baseSplit = simpleForm ? 4. : 5.;
    float minimumSplit = simpleForm ? 3. : 2.;
    vec2 complexity = baseSplit * (pow(vec2(rand(seed+0.),rand(seed+1.)),vec2(0.2)) * 0.8 + 0.25);
    vec2 sep = floor(max(vec2(minimumSplit), complexity*pow(s,vec2(0.65))));
    vec3 col = vec3(0);
    
    // Splitting
    seed = floor(seed * 15.) / 15.;
    bool spi = rand(seed+2.) < 0.4;
    float basePattern = spi ? 0.9 : smoothstep(0., 0.2, rand(seed+3.)) * 1.0;
    float sepPattern = spi ? 1.0 : floor((sep.x + sep.y + 2.) * 0.3);
    seed = basePattern + floor(fract(seed*123.456) * sepPattern) * 3.1415 + floor(iTime*0.9+0.5);
    vec3 c = spi ? mix(vec3(0,0.5,1),vec3(1,0.5,1),smoothstep(0.,2.,p.x+p.y)) * 0.8 + 0.2 : vec3(1.0);
    //c = fract(vec3(seed.xy,seed.x+seed.y)*20.*vec3(1.123589,1.589312,1.942012));
  	//c = vec3(1.);
    
    // Points
    vec2 place = p*s/(s-line)*(sep-1.);
    vec2 pixs = fract(place)*(s-line)/(sep-1.);
    if(rand(seed + floor(place)) < 0.3) {
        col = max(col, max(pixs.x, pixs.y) < line ? c : vec3(0.));
    }
    
    // Random Branching
    vec2 edgeSeed = floor(place);
    edgeSeed += pixs.x < pixs.y ? 3. : 4.;
    float bridge = rand(seed + edgeSeed);
    float bridgeRatio = simpleForm ? 0.9 : 0.9;
    //col = max(col, min(pixs.x, pixs.y) < line && bridge > bridgeRatio ? c : vec3(0.));
    
    // Tree construction
    float mu = 0.478213;
    for(int i=0;i<4;i++) {
        if(i!=0 && rand(seed) < 0.8 || rand(seed+2.) < 0.5) {
            p = p.yx;
            s = s.yx;
            sep = sep.yx;
        }
        float ix = floor(centerize(rand(seed+3.))*(sep.x-1.)+0.5);
        float split = ix/(sep.x-1.)*(s.x-line) + line / 2.;
        col = max(col, distance(p.x*s.x, split) < line / 2. ? c : vec3(0.));
        if(p.x*s.x < split - line/2.) {
            float nsep = ix + 1.;
            float ns = s.x/(s.x-line)*(sep.x-1.) - (sep.x - ix - 1.);
            ns = ns*(s.x-line)/(sep.x-1.);
            p.x = p.x*s.x / ns;
            s.x = ns;
            sep.x = nsep;
            seed = seed + mu;
        } else if(p.x*s.x > split + line/2.) {
            float nsep = sep.x - ix;
            float ns = s.x/(s.x-line)*(sep.x-1.) - ix;
            ns = ns*(s.x-line)/(sep.x-1.);
            p.x = (p.x*s.x - split + line/2.) / ns;
            s.x = ns;
            sep.x = nsep;
            seed = seed - mu;
        } else {
        	return col;
        }
        mu /= 2.0;
        if(p.x < 0. || p.x > 1. || p.y < 0. || p.y > 1. || sep.x < 1.5) return col;
    }
    
	return col;
}

vec3 draw(vec2 p, vec2 seed) {
    float d = 1.;
    bool simpleForm = rand(seed-1.) > 0.8;
    bool global = !simpleForm;
    vec3 col = vec3(1);
    vec2 size = vec2(1);
    float mu = sqrt(2.);
    float blank = 0.11;
	bool flipped = false;
    for(int i=0;i<2;i++) {
        bool refuse = false;
        if(global) {
            bool dir = rand(seed) < 0.5;
            if(dir) {
                p = p.yx;
                size = size.yx;
                flipped = !flipped;
            }
            float ratio = rand(seed+1.);
            ratio = ratio < 0.3 ? 0.3
                  : ratio < 0.5 ? 0.5
                                : 0.65;
            if(size.x < 0.7) ratio = 0.4;
            if(i!=0 &&  dir && size.x < 0.7) refuse = true;            
            if(i!=0 && !dir && size.x < 0.7) refuse = true;
            if(!refuse) {
                if(p.x < ratio) {
                    float w = ratio * size.x - blank / 2.;
                    p.x /= w / size.x;
                    size.x *= w / size.x;
                    seed += 0.2;
                } else {
                    float pad = ratio * size.x + blank / 2.;
                    float w = (1.-ratio) * size.x - blank / 2.;
                    p.x -= pad / size.x;
                    p.x /= w / size.x;
                    size.x *= w / size.x;
                }
            }
            seed.xy += ratio * mu * seed.yx;
            if(p.x < 0. || p.x > 1.) {
                col = vec3(0.);
                break;
            }
        }
        mu /= sqrt(3.0);
    }
    if(flipped) {
    	p = p.yx;
        size = size.yx;
    }
    col *= pieces(p, size, seed, simpleForm);
    //col.rg *= size;
    float w = 0.1;
    //vec3 col = vec3(1) * smoothstep(w*0.5+0.01,w*0.5-0.01,d);
    return col;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec3 col = vec3(1);
    
    vec2 uv = (fragCoord - iResolution.xy * 0.5) / iResolution.y;
    uv *= 7.0;
    uv.y += iTime-4.;
    vec2 seed = floor(uv+0.5) * 0.1;
    uv = fract(uv+0.5)-0.5;
    uv = uv*1.3;
    float d = max(abs(uv.x),abs(uv.y));
    
    if(d > 0.5) {
        col = vec3(0);
    } else {
        // uv: [-0.5,0.5]^2
        seed.x += floor(iTime*0.9);
        col = draw(uv+0.5, seed);
    }
    
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

